# Convert a binary PPM file into raw 565 RGB texture format.
import glide, struct
def glideSize(size):
	if size == 256:
		return glide.GR_LOD_LOG2_256
	if size == 128:
		return glide.GR_LOD_LOG2_128
	if size == 64:
		return glide.GR_LOD_LOG2_64
	if size == 32:
		return glide.GR_LOD_LOG2_32
	if size == 16:
		return glide.GR_LOD_LOG2_16
	if size == 8:
		return glide.GR_LOD_LOG2_8
	if size == 4:
		return glide.GR_LOD_LOG2_4
	if size == 2:
		return glide.GR_LOD_LOG2_2
	if size == 1:
		return glide.GR_LOD_LOG2_1

def readHeader(file):
	fread = file.read
	header = fread(2)
	if header != 'P6':
		raise 'FileNotRecognised'
	nums = []; currnum = 0; innum = 0
	while 1:
		c = fread(1)
		if c=='#':
			while c != '\n':
				c = file.read(1)
		if c in '0123456789':
			innum = 1
			currnum = (currnum * 10) + ord(c) - ord('0')
		else:
			if innum:
				innum = 0
				nums.append(currnum)
				currnum = 0
				if len(nums) == 3:
					while c != '\n':
						c = fread(1)
					return nums

def main():
	import sys, string
	infile = open(sys.argv[1], 'rb')
	outfile = open(sys.argv[2], 'wb')
	[width, height, maxval] = readHeader(infile)
	outfile.write(chr(glideSize(width)) + chr(glideSize(height)))
	rwidth = range(width)
	rheight = range(height)
	for h in rheight:
		for w in rwidth:
			rc,gc,bc = infile.read(3)
			r = ord(rc); g = ord(gc); b = ord(bc)
			word = (((r>>3)<<11) | ((g>>2)<<5) | (b>>3)) & 0xffff
			outfile.write(struct.pack('h', word))
	infile.close()
	outfile.close()

main()