/* File: Wsc.i */
%module sio
%{
#include "windows.h"
#include "Wsc.h"
%}

extern int SioBaud(int,unsigned);
extern int SioBrkSig(int,char);
extern int SioCTS(int);
extern int SioDCD(int);
extern int SioDebug(int);
extern int SioDone(int);
extern int SioDSR(int);
extern int SioDTR(int,char);
extern int SioFlow(int,char);
extern int SioInfo(char);
extern int SioGetc(int);
extern int SioGets(int,char*,unsigned);
extern int SioParms(int,int,int,int);
extern int SioPutc(int,char);
extern int SioPuts(int,char*,unsigned);
extern int SioReset(int,int,int);
extern int SioRI(int);
extern int SioRTS(int,char);
extern int SioRxClear(int);
extern int SioRxQue(int);
extern int SioStatus(int,unsigned);
extern int SioTxClear(int);
extern int SioTxQue(int);
extern int SioUnGetc(int,char);
extern int SioWinError(void);

#define COM1   0
#define COM2   1
#define COM3   2
#define COM4   3
#define COM5   4
#define COM6   5
#define COM7   6
#define COM8   7
#define COM9   8

/* Parity Codes */

#define NoParity 0
#define OddParity  1
#define EvenParity 2
#define MarkParity 3
#define SpaceParity 4

/* Stop Bit Codes */

#define OneStopBit  0
#define TwoStopBits 2

/* Word Length Codes */

#define WordLength5  5
#define WordLength6  6
#define WordLength7  7
#define WordLength8  8

/* return codes */

#define WSC_NO_DATA   (-100)
#define WSC_RANGE     (-101)
#define WSC_ABORTED   (-102)
#define WSC_WIN32ERR  (-103)
#define WSC_EXPIRED   (-104)
#define IE_BADID      (-1)
#define IE_OPEN       (-2)
#define IE_NOPEN      (-3)
#define IE_MEMORY     (-4)
#define IE_DEFAULT    (-5)
#define IE_HARDWARE   (-10)
#define IE_BYTESIZE   (-11)
#define IE_BAUDRATE   (-12)

/* baud codes */

#define Baud110    0
#define Baud300    1
#define Baud1200   2
#define Baud2400   3
#define Baud4800   4
#define Baud9600   5
#define Baud19200  6
#define Baud38400  7
#define Baud57600  8
#define Baud115200 9

/* SioGetError masks */

#define WSC_RXOVER   0x0001
#define WSC_OVERRUN  0x0002
#define WSC_PARITY   0x0004
#define WSC_FRAME    0x0008
#define WSC_BREAK    0x0010
#define WSC_TXFULL   0x0100
