"""
Author:            Arpad Kiss, sekter@mail.matav.hu
Modified:          1999.06.21.
Platform:          -
Description:       ComboBox widget, version 0.70
                   With cget you can get the values of value,mandatory,value_error,value_error_description,
                   coming from Entry widget+cbx['listbox'] returns the Listbox widget.
                   With configure you can set value, mandatory, validate_function and the properties of Entry( except
                   'state', with it you set the 'state' of the Entry and the Button)
                   Validation occurs automaticly when you leave the field, but it doesn't occur when you set
                   the value. So you have to call the Validate method after value setting if you want to refresh 
		   the  value_error_description and set the state_args.
                   All variables/functions begining with an underscore are considered as local. Don't set them from
                   outside of the class.

Todos:             Upper case and lower case conversion for accented characters doesn't work. 
"""



#Imports
#************************************************************************************************************
from Tkinter     import *
from Tkinter import _cnfmerge
import string
#************************************************************************************************************



#Constants
#************************************************************************************************************
#************************************************************************************************************


	    
#
# The ComboBox control
# value returns the value of the StringEntry(it must be string)
#************************************************************************************************************
class ComboBox(Frame):

    # state_args=(dict of enabled args, dict of disabled args,dict of valueerror args)
    def __init__(self,parent=None,state_args=({'bg':'green'},{'bg':'blue'},{'bg':'red'}),listbox_kw={},**kw):
	self._value=StringVar()     #value in the entry
	self._mandatory=NO
	self._validate_function=lambda x: TRUE
	self._error_messages=((0,0,'This field is mandatory!'),
	                      (0,1,"This text doesn't exist in the list!")) #((0,error number,error text),..); the first number is 1 if this message come from self._validate_function
	self._value_error_description=None
	self._parent=parent
	self._enabled_args,self._disabled_args,self._error_args=state_args
	self._listbox_kw=listbox_kw       #attributes of Listbox
	Frame.__init__(self,parent,borderwidth=0)
	self._ent=Entry(self)
	self._bmp=BitmapImage(data='#define bmp_width 16'+chr(10)+
	                           '#define bmp_height 16'+chr(10)+
				   'static char bmp_bits[] = {'+chr(10)+
				   '0x0, 0x0, 0xc0, 0x3, 0x40, 0x2, 0x40, 0x2, 0x40, 0x2, 0x40, 0x2, 0x40, 0x2, 0x40, 0x2, 0x7c, 0x3e, 0x8, 0x10, 0x10, 0x8, 0x20, 0x4, 0x40, 0x2, 0x80, 0x1, 0xfc, 0x3f, 0x0, 0x0};',
				   background='')
	tmpheight=self.winfo_reqheight()
	self._btn=Button(self,text='V',command=self._DropDown,takefocus=NO,relief=GROOVE,image=self._bmp,height=tmpheight)
	self._ent['textvariable']=self._value
	self._btn['cursor']='arrow'
	self._ent.pack(side=LEFT,expand=YES,fill=BOTH)
	self._btn.pack(side=LEFT,fill=BOTH)
	self.configure(kw)
	self.Validate()
	#listbox
	self._toplevel=Toplevel(self)
	self._toplevel.overrideredirect(1) # no title
	self._toplevel.withdraw() #not visible
	self._listbox = Listbox(self._toplevel,self._listbox_kw)
	self._listbox.pack(side=LEFT,expand=YES,fill=BOTH,padx=1,pady=1)	
	#binds
	self.bind("<FocusOut>", self._FocusOut)
	self._ent.bind("<Return>", self._DropDown)
	self._ent.bind("<Double-1>", self._DropDown)
	self._toplevel.bind("<Return>", self._listbox_SelectItem)
        self._toplevel.bind("<Escape>", self._toplevel_WithDraw)
        self._toplevel.bind("<KeyPress>", self._toplevel_KeyPress)
        self._toplevel.bind("<FocusOut>", self._toplevel_WithDraw)
	self._listbox.bind('<Double-1>', self._listbox_SelectItem)
    
    def configure(self,cnf={},**kw):
	if kw:
		kw = _cnfmerge((cnf,kw))
	else:
		kw=_cnfmerge(cnf)
	self._PreConfig(kw)
	#preprocessing the class specific properties
	self._PreConfig(kw)
	# if we come from self._SetState then we have to delete the 'From_SetState' key
	# and after configuring the self._ent we have to call the self._SetState if 'state' is a key in kw/p, this occurs
	# when you set the 'state' property outside of this class(and we have to aply the state_args)
	From_SetState=FALSE
	if kw.has_key('From_SetState'):
	    del kw['From_SetState']
	    From_SetState=TRUE
	self._ent.configure(kw)
	if not From_SetState and kw.has_key('state'): self._SetState()

    #preprocessing the class specific properties
    def _PreConfig(self,kw):
	if kw.has_key('value'):
	    self._value.set(str(kw['value']))
	    self._value_error_description=None
	    del kw['value']
	if kw.has_key('mandatory'):
	    self._mandatory=kw['mandatory']
	    del kw['mandatory']
	if kw.has_key('validate_function'):
	    self._validate_function=kw['validate_function']
	    del kw['validate_function']
	if kw.has_key('error_messages'):
	    self._error_messages=kw['error_messages']
	    del kw['error_messages']
	#we have to set the 'state' of the button too
	if kw.has_key('state'):
	    self._btn['state']=kw['state']
	    
    def cget(self,parKey):
	if parKey=='value':
	    if len(string.strip(self._value.get()))==0:
		return None
	    else:
		return self._value.get()
	elif parKey=='value_error':
	    return self._value_error_description!=None
	else:
	    try:
		return eval('self._%s' % parKey)
	    except:
		return self._ent.cget(parKey)

    __getitem__=cget

    # this shows the Listbox 
    def _DropDown(self, event=None):
	if not self["state"]==DISABLED:
	    if self._toplevel.wm_state()=='withdrawn':
		tmpc=self['cursor']
		self['cursor']='watch'
		self.event_generate('<<DropDown>>')
		#move to the first index that match the entry value
		for i in range(self._listbox.size()):
		    if  self._value.get()<>'' and string.lower(self._value.get())==string.lower(self._listbox.get(i)[:len(self._value.get())]):
			if self._listbox.curselection(): self._listbox.select_clear(self._listbox.curselection())
			self._listbox.select_set(i)
			self._listbox.activate(i)
			self._listbox.yview(i)
			break
		#make it visible
		self._toplevel.wm_deiconify()
	        self._toplevel.tkraise()
		self._toplevel.geometry("%dx%d+%d+%d" % (self.winfo_width()-self._btn.winfo_width(),self._toplevel.winfo_reqheight(),self.winfo_rootx(),
                                       self.winfo_rooty()+self.winfo_height()))
		self._listbox.focus_force()
		#resizing the listbox
		if self._listbox['height']>0:
		    #height may be not enough to hold all the elements
		    if self._listbox.size()>int(self._listbox['height']):
			#the listbox has fewer lines than it has to show
			#it needs scrollbar
			self.vbar=Scrollbar(self._toplevel,relief=GROOVE)
			self.vbar.pack(side=LEFT,fill=Y,padx=1,pady=1)
			self._listbox['yscrollcommand']=self.vbar.set
			self.vbar['command']=self._listbox.yview
			self._toplevel.geometry("%dx%d" % (self.winfo_width()-self._btn.winfo_width()+self.vbar.winfo_reqwidth(),self._toplevel.winfo_reqheight()))
		self['cursor']=tmpc

    # we have to validate the value when leave this widget
    def _FocusOut(self, event=None):
	self.Validate()

    # aply the right state_args depend on the value of self['state']
    def _SetState(self):
	if self['state'] == NORMAL:
	    if self._value_error_description!=None:
		kw=self._error_args
	    else:
		kw=self._enabled_args
	else:
	    kw=self._disabled_args
	#in self.configure we check the existence of 'From_SetState' key
	# without it the self.configure(kw) may cause an infinitive recursion
	kw['From_SetState']=TRUE
	self.configure(kw)
	    
    # it validates the value of the self._ent
    def Validate(self):
	try:
	    if self._mandatory and len(string.strip(self._ent.get()))==0:
		raise ValueError,self._error_messages[0]
	    self._validate_function(self)
	    self._value_error_description=None
	    self._SetState()
	    return TRUE
	except ValueError,instance:
	    self._value_error_description=instance
	    self._SetState()
	    return FALSE

    def _listbox_SelectItem(self, event=None):
	self._toplevel.withdraw()
        self.update_idletasks()
	self._PreConfig({'value':self._listbox.get(self._listbox.index(ACTIVE))})
	self.Validate()
	self._SetState()

    def _toplevel_WithDraw(self, event=None):
	self._toplevel.withdraw()
        self.update_idletasks()

    # if you press a key then this rutin select the first item begins with it
    def _toplevel_KeyPress(self, event=None):
	if event.char in tuple(string.lowercase) or event.char in tuple(string.uppercase):
	    tmpup=string.upper(event.char)
	    tmplo=string.lower(tmpup)
	    for i in range(self._listbox.size()):
	    	if  tmplo==self._listbox.get(i)[:1] or tmpup==self._listbox.get(i)[:1]:
		    if self._listbox.curselection(): self._listbox.select_clear(self._listbox.curselection())
		    self._listbox.select_set(i) 
		    self._listbox.activate(i)
		    self._listbox.yview(i)
		    break

#************************************************************************************************************



#Test
#************************************************************************************************************
def test():
    def FillList(event=None):
	event.widget['listbox'].delete(0,END)
	for itext in ('first','second','third'):
	    event.widget['listbox'].insert(END,itext)

    root=Tk()
    
    # validation functions
    def ValidateFunc(self):
	if self._value.get()!='nine': raise ValueError,(1,0,"It has to be 'nine'!")
    def ValidateFunc2(self):
	if not self._value.get() in  ('first','second','third'): raise ValueError,self._error_messages[1]
	
    #disabled ComboBox
    cbx=ComboBox(root,({'bg':'green'},{'bg':'gray'},{'bg':'red'}))
    cbx.pack(fill=BOTH,expand=YES)
    cbx.configure(state=DISABLED)
    
    cbx2=ComboBox(root,({'bg':'green'},{'bg':'gray'},{'bg':'red'}),{'bg':'lightblue','fg':'maroon'},validate_function=ValidateFunc,mandatory=YES)
    cbx2.pack(fill=BOTH,expand=YES)
    for itext in ('one','two','three','four','five','six','seven','eight','nine','ten','eleven'):
	cbx2['listbox'].insert(END,itext)
    
    #this is filled dinamically
    # if you want localized messages then you can replace the default messages
    # in this case don't forget the validation function
    messages=((0,0,'*** This  is a mandatory field! ***'),
              (0,1,"*** There is a wrong value in the field! ***"))
    cbx3=ComboBox(root,({'bg':'green'},{'bg':'gray'},{'bg':'red'}),error_messages=messages,validate_function=ValidateFunc2)
    cbx3.pack(fill=BOTH,expand=YES)
    cbx3.bind('<<DropDown>>',FillList)
    
    root.mainloop()
    
    print 'cbx value,value_error,value_error_description:',cbx['value'],',',cbx['value_error'],cbx['value_error_description']
    print 'cbx2 value,value_error,value_error_description:',cbx2['value'],',',cbx2['value_error'],cbx2['value_error_description']
    print 'cbx3 value,value_error,value_error_description:',cbx3['value'],',',cbx3['value_error'],cbx3['value_error_description']

    
    
if __name__=='__main__':
    test()
